/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class FireAmmoAction
extends AbstractGameAction {
    private AbstractPlayer player;
    private AbstractMonster target;
    private AbstractCard card;
    private int fireCount;

    public FireAmmoAction(AbstractPlayer p, AbstractMonster t, AbstractCard c) {
        this(p, t, c, 1);
    }

    public FireAmmoAction(AbstractPlayer p, AbstractMonster t, AbstractCard c, int numFired) {
        this.player = p;
        this.target = t;
        this.card = c;
        this.fireCount = numFired;
        this.duration = Settings.ACTION_DUR_FAST;
        this.actionType = AbstractGameAction.ActionType.CARD_MANIPULATION;
    }

    @Override
    public void update() {
        if (this.duration == Settings.ACTION_DUR_FAST) {
            for (int i = 0; i < this.fireCount; ++i) {
                this.card.fire(this.player, this.target);
            }
            if (this.card.exhaustOnFire) {
                this.player.hand.moveToExhaustPile(this.card);
                CardCrawlGame.dungeon.checkForPurityAndPactAchievement();
            } else {
                this.player.hand.moveToDiscardPile(this.card);
            }
            AbstractDungeon.player.hand.refreshHandLayout();
            this.isDone = true;
        }
        this.tickDuration();
    }
}

